<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMainAddressesTable extends Migration {

	public function up()
	{
		Schema::create('main_addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('company_id')->unsigned();
			$table->enum('type', array('by_registration', 'by_domicile', 'by_project_execution'));
			$table->string('address');
			$table->string('additional_address')->nullable();
			$table->string('city');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('main_addresses');
	}
}