<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubmittedDataTable extends Migration {

	public function up()
	{
		Schema::create('submitted_data', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('company_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->softDeletes();
			$table->enum('status', array('new', 'complated'));
			$table->timestamps();
			$table->timestamp('completed_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('submitted_data');
	}
}