<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('pages', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('pages')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('translations', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('languages')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('translations', function(Blueprint $table) {
			$table->foreign('page_id')->references('id')->on('pages')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('pages', function(Blueprint $table) {
			$table->dropForeign('pages_parent_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_role_id_foreign');
		});
		Schema::table('translations', function(Blueprint $table) {
			$table->dropForeign('translations_language_id_foreign');
		});
		Schema::table('translations', function(Blueprint $table) {
			$table->dropForeign('translations_page_id_foreign');
		});
	}
}