<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMemberTable extends Migration {

	public function up()
	{
		Schema::create('member', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->unsigned();
			$table->string('name', 250);
			$table->tinyInteger('gender');
			$table->integer('country');
			$table->text('address');
			$table->integer('city');
			$table->integer('state');
			$table->integer('pincode');
		});
	}

	public function down()
	{
		Schema::drop('member');
	}
}