<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 250)->default('NULL');
			$table->string('email', 250);
			$table->string('password', 250);
			$table->string('confirmation_code', 250);
			$table->bigInteger('mobile');
			$table->integer('role_id');
			$table->tinyInteger('confirmed')->default('1');
			$table->string('remember_token', 100);
			$table->tinyInteger('status');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}