<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('secteurs', function(Blueprint $table) {
			$table->foreign('categorie_id')->references('id')->on('categorie')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('secteurs', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('offres', function(Blueprint $table) {
			$table->foreign('secteur_id')->references('id')->on('secteurs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('offres', function(Blueprint $table) {
			$table->foreign('categorie_id')->references('id')->on('categorie')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('offres', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('demandeurs', function(Blueprint $table) {
			$table->foreign('categorie_id')->references('id')->on('categorie')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('userCategories', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('userCategories', function(Blueprint $table) {
			$table->foreign('categorie_id')->references('id')->on('categorie')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('secteurs', function(Blueprint $table) {
			$table->dropForeign('secteurs_categorie_id_foreign');
		});
		Schema::table('secteurs', function(Blueprint $table) {
			$table->dropForeign('secteurs_user_id_foreign');
		});
		Schema::table('offres', function(Blueprint $table) {
			$table->dropForeign('offres_secteur_id_foreign');
		});
		Schema::table('offres', function(Blueprint $table) {
			$table->dropForeign('offres_categorie_id_foreign');
		});
		Schema::table('offres', function(Blueprint $table) {
			$table->dropForeign('offres_user_id_foreign');
		});
		Schema::table('demandeurs', function(Blueprint $table) {
			$table->dropForeign('demandeurs_categorie_id_foreign');
		});
		Schema::table('userCategories', function(Blueprint $table) {
			$table->dropForeign('userCategories_user_id_foreign');
		});
		Schema::table('userCategories', function(Blueprint $table) {
			$table->dropForeign('userCategories_categorie_id_foreign');
		});
	}
}