<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ApplicationSubmission extends Model 
{

    protected $table = 'ApplicationSubmission';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $guarded = array('editToken');
    protected $fillable = array('data', 'email', 'status');
    protected $visible = array('data', 'email', 'status');
    protected $hidden = array('editToken');

    public function scores()
    {
        return $this->hasMany('SubmissionScore', 'submission_id');
    }

    public function form()
    {
        return $this->belongsTo('FormDefinition');
    }

}