<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateApplicationSubmissionTable extends Migration {

	public function up()
	{
		Schema::create('ApplicationSubmission', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->text('data');
			$table->string('email', 128);
			$table->string('editToken', 64);
			$table->datetime('tokenExpires');
			$table->integer('form_id')->unsigned();
			$table->enum('status', array('Submitted', 'Reviewed', 'Scored', 'Rejected', 'Accepted', 'Archived', ''));
		});
	}

	public function down()
	{
		Schema::drop('ApplicationSubmission');
	}
}