<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('Users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('email', 128);
			$table->string('password', 128);
			$table->string('firstName', 64);
			$table->string('lastName', 64);
			$table->enum('role', array('Viewer', 'Creator', 'Moderator', 'Adjudicator', 'GroupAdministrator', 'SystemAdministrator'));
		});
	}

	public function down()
	{
		Schema::drop('Users');
	}
}