<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAcpNavigationTable extends Migration {

	public function up()
	{
		Schema::create('acp_navigation', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('parent_link_id')->unsigned()->nullable();
			$table->string('name', 255);
			$table->string('short_description', 255);
			$table->text('long_description');
			$table->string('short_label', 255);
			$table->string('long_label', 255);
			$table->enum('link_type', array('external', 'internal'));
			$table->string('url', 255);
			$table->smallInteger('order')->nullable();
			$table->string('icon_type', 255);
			$table->string('icon', 100);
			$table->mediumInteger('menu_level');
			$table->boolean('has_children');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('acp_navigation');
	}
}