<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('organizations_orders', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('organizations_orders', function(Blueprint $table) {
			$table->foreign('organization_id')->references('id')->on('organizations')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('stores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('ordertaken_by')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('orderdetails', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orderdetails', function(Blueprint $table) {
			$table->foreign('menuitem_id')->references('id')->on('menuitems')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('subdomains', function(Blueprint $table) {
			$table->foreign('organization_id')->references('id')->on('organizations')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('addresses_contacts', function(Blueprint $table) {
			$table->foreign('contact_id')->references('id')->on('contacts')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('organizations_orders', function(Blueprint $table) {
			$table->dropForeign('organizations_orders_order_id_foreign');
		});
		Schema::table('organizations_orders', function(Blueprint $table) {
			$table->dropForeign('organizations_orders_organization_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_store_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_ordertaken_by_foreign');
		});
		Schema::table('orderdetails', function(Blueprint $table) {
			$table->dropForeign('orderdetails_order_id_foreign');
		});
		Schema::table('orderdetails', function(Blueprint $table) {
			$table->dropForeign('orderdetails_menuitem_id_foreign');
		});
		Schema::table('subdomains', function(Blueprint $table) {
			$table->dropForeign('subdomains_organization_id_foreign');
		});
		Schema::table('addresses_contacts', function(Blueprint $table) {
			$table->dropForeign('addresses_contacts_contact_id_foreign');
		});
	}
}