<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class GiftCardOrder extends Model 
{

    protected $table = 'gift_card_orders';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function customer()
    {
        return $this->belongsTo('App\Customer');
    }

    public function giftCard()
    {
        return $this->belongsTo('App\GiftCard');
    }

}