<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('name_ar');
			$table->string('sku');
			$table->string('slug');
			$table->string('price');
			$table->string('image');
			$table->string('video');
			$table->longText('description');
			$table->longText('description_ar');
			$table->longText('ingredients');
			$table->longText('ingredients_ar');
			$table->string('stock');
			$table->tinyInteger('status');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('brand_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}