<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('otp', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('customer_addresses', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('brands')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('payment_method_id')->references('id')->on('payment_methods')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('customer_loyalties', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('wallet_details', function(Blueprint $table) {
			$table->foreign('wallet_id')->references('id')->on('wallets')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('gift_card_orders', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('product_videos', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('product_features', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('product_highlights', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('product_collection', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('otp', function(Blueprint $table) {
			$table->dropForeign('otp_customer_id_foreign');
		});
		Schema::table('customer_addresses', function(Blueprint $table) {
			$table->dropForeign('customer_addresses_customer_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_brand_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_payment_method_id_foreign');
		});
		Schema::table('customer_loyalties', function(Blueprint $table) {
			$table->dropForeign('customer_loyalties_customer_id_foreign');
		});
		Schema::table('wallet_details', function(Blueprint $table) {
			$table->dropForeign('wallet_details_wallet_id_foreign');
		});
		Schema::table('gift_card_orders', function(Blueprint $table) {
			$table->dropForeign('gift_card_orders_customer_id_foreign');
		});
		Schema::table('product_videos', function(Blueprint $table) {
			$table->dropForeign('product_videos_product_id_foreign');
		});
		Schema::table('product_features', function(Blueprint $table) {
			$table->dropForeign('product_features_product_id_foreign');
		});
		Schema::table('product_highlights', function(Blueprint $table) {
			$table->dropForeign('product_highlights_product_id_foreign');
		});
		Schema::table('product_collection', function(Blueprint $table) {
			$table->dropForeign('product_collection_product_id_foreign');
		});
	}
}