<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOffersTable extends Migration {

	public function up()
	{
		Schema::create('offers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title');
			$table->string('title_ar');
			$table->string('description')->nullable();
			$table->string('description_ar')->nullable();
			$table->datetime('from_date');
			$table->datetime('to_date');
			$table->enum('type', array(''Percentage'', ''Flat'', ''Combo'', ''BOGO'', ''Bundle''));
			$table->integer('value');
			$table->integer('maximum_value')->nullable();
			$table->tinyInteger('status')->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('offers');
	}
}