<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductCollectionTable extends Migration {

	public function up()
	{
		Schema::create('product_collection', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('product_id')->unsigned();
			$table->string('collection_name', 100);
			$table->string('collection_title', 100);
			$table->timestamps();
			$table->timestamp('softDeletes');
		});
	}

	public function down()
	{
		Schema::drop('product_collection');
	}
}