<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductTable extends Migration {

	public function up()
	{
		Schema::create('product', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('product_name', 255);
			$table->integer('category_id')->unsigned();
			$table->integer('subcategory_id')->unsigned();
			$table->text('description')->nullable();
			$table->enum('status', array('Active', 'Inactive'));
			$table->integer('vendor_id')->unsigned();
			$table->string('image');
			$table->decimal('price');
		});
	}

	public function down()
	{
		Schema::drop('product');
	}
}