<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateShopTable extends Migration {

	public function up()
	{
		Schema::create('shop', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('vendor_id')->unsigned();
			$table->string('shop_name', 255);
			$table->string('tag_line', 191)->nullable();
			$table->text('address')->nullable();
			$table->string('mobile_no')->nullable();
			$table->integer('product_min_qty');
			$table->integer('min_qty_unit')->unsigned();
			$table->integer('product_max_qty');
			$table->integer('max_qty_unit')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('shop');
	}
}