<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventsTable extends Migration {

	public function up()
	{
		Schema::create('events', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title', 150);
			$table->string('image', 100)->default('default.png');
			$table->text('description');
			$table->date('start_at');
			$table->date('end_at');
			$table->text('location');
		});
	}

	public function down()
	{
		Schema::drop('events');
	}
}