<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNewsTable extends Migration {

	public function up()
	{
		Schema::create('news', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('image', 100)->default('default.png');
			$table->date('date');
			$table->string('title', 255);
			$table->text('description');
			$table->integer('tag_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('news');
	}
}