<?php

namespace App\Models;

class Address extends Eloquent {

	protected $table = 'addresses';
	public $timestamps = true;
	protected $fillable = array('city_id', 'client_id', 'address_line');

	public function city()
	{
		return $this->belongsTo('City');
	}

	public function orders()
	{
		return $this->hasMany('Order');
	}

	public function client()
	{
		return $this->belongsTo('Client');
	}

}