<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInquiryTable extends Migration {

	public function up()
	{
		Schema::create('inquiry', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->nullable();
			$table->integer('real_id')->unsigned();
			$table->string('email')->nullable();
			$table->string('phone')->nullable();
			$table->string('message', 500)->nullable();
			$table->enum('status', array('0', '1'))->nullable();
			$table->string('note', 500)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('inquiry');
	}
}