<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('email');
			$table->string('password');
			$table->enum('type', array('1', '2', '3', '4', '5', '6', '7', '8'));
			$table->string('cities_id')->nullable();
			$table->string('phone')->nullable();
			$table->string('logo_image', 500)->nullable();
			$table->string('license_image')->nullable();
			$table->integer('user_id')->unsigned();
			$table->string('nationality')->nullable();
			$table->string('sex')->nullable();
			$table->date('date_of_brth');
			$table->string('passport_image', 500)->nullable();
			$table->string('id_image', 500)->nullable();
			$table->string('visa_image', 500)->nullable();
			$table->string('addrse')->nullable();
			$table->string('government_name');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}