<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventTable extends Migration {

	public function up()
	{
		Schema::create('Event', function(Blueprint $table) {
			$table->increments('id', true);
			$table->timestamps();
			$table->string('title');
			$table->date('start_date');
			$table->date('end_date');
			$table->string('picture');
			$table->integer('organisation_id')->unsigned()->index();
			$table->string('place');
		});
	}

	public function down()
	{
		Schema::drop('Event');
	}
}