<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Category', function(Blueprint $table) {
			$table->foreign('attribute_id')->references('id')->on('Attribute')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Product', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('Category')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Order', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Payment', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('Order')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Order_detail', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('Order')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Transaction', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('Order')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Transaction', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('Product')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Category', function(Blueprint $table) {
			$table->dropForeign('Category_attribute_id_foreign');
		});
		Schema::table('Product', function(Blueprint $table) {
			$table->dropForeign('Product_category_id_foreign');
		});
		Schema::table('Order', function(Blueprint $table) {
			$table->dropForeign('Order_user_id_foreign');
		});
		Schema::table('Payment', function(Blueprint $table) {
			$table->dropForeign('Payment_order_id_foreign');
		});
		Schema::table('Order_detail', function(Blueprint $table) {
			$table->dropForeign('Order_detail_order_id_foreign');
		});
		Schema::table('Transaction', function(Blueprint $table) {
			$table->dropForeign('Transaction_order_id_foreign');
		});
		Schema::table('Transaction', function(Blueprint $table) {
			$table->dropForeign('Transaction_product_id_foreign');
		});
	}
}