<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductTable extends Migration {

	public function up()
	{
		Schema::create('Product', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('category_id')->unsigned();
			$table->string('title', 64);
			$table->string('description', 255);
			$table->string('image', 64);
			$table->integer('quantity');
			$table->integer('unit_price');
			$table->integer('discount_price')->nullable();
			$table->string('slug', 32);
			$table->string('status', 16);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Product');
	}
}