<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderTable extends Migration {

	public function up()
	{
		Schema::create('Order', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('delivery_charge', 32);
			$table->decimal('discount_price');
			$table->decimal('payable_total', 16);
			$table->text('receiver_name');
			$table->string('receiver_phone', 32)->nullable();
			$table->string('receiver_address');
			$table->string('status', 10)->default('pending');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('Order');
	}
}