<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCashiersTable extends Migration {

	public function up()
	{
		Schema::create('cashiers', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('cashiercash_id')->unsigned()->default('0');
			$table->enum('status_process', array('Menunggu', 'Disiapkan', 'Diterima', 'Selesai', 'Dibatalkan'));
			$table->string('cashier_number', 15);
			$table->date('transaction_date');
			$table->integer('total_item')->default('0');
			$table->decimal('total_amount', 18,2)->default('0');
			$table->decimal('total_discount', 18,2)->default('0');
			$table->decimal('grand_total', 18,2)->default('0');
			$table->integer('created_by')->unsigned()->default('0');
			$table->enum('payment_method', array('cash', 'plafond'));
			$table->integer('updated_by')->unsigned()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('cashiers');
	}
}