<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStocksTable extends Migration {

	public function up()
	{
		Schema::create('stocks', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('product_id')->unsigned();
			$table->integer('location_id')->unsigned();
			$table->date('expired_date');
			$table->decimal('stock', 10,2)->default('0');
			$table->integer('created_by')->unsigned()->default('0');
			$table->integer('updated_by')->unsigned()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('stocks');
	}
}