<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePrizeCategoryTable extends Migration {

	public function up()
	{
		Schema::create('prize_category', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name')->unique();
			$table->boolean('no_prize')->default(0);
			$table->string('img_url');
			$table->boolean('coupon')->default(0);
			$table->tinyInteger('order');
			$table->integer('campaign_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('prize_category');
	}
}