<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLayerTable extends Migration {

	public function up()
	{
		Schema::create('layer', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('collection_id')->nullable();
			$table->integer('rarity')->nullable()->default('100');
			$table->string('name')->nullable();
			$table->boolean('is_override')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('layer');
	}
}