<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWhiteListUserTable extends Migration {

	public function up()
	{
		Schema::create('white_list_user', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('white_list_id')->nullable();
			$table->text('address')->nullable();
			$table->boolean('validated')->nullable()->default(0);
			$table->enum('source', array('discord', 'web', 'direct'))->nullable();
			$table->string('username')->nullable();
			$table->string('userid', 100)->nullable();
			$table->text('signature')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('white_list_user');
	}
}