<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class WithdrawalAddress extends Model 
{

    protected $table = 'withdrawal_address';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('address', 'contract_id', 'share');

    public function contract()
    {
        return $this->belongsTo('Contract', 'contract_id');
    }

}