<?php

namespace social;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Social extends Model 
{

    protected $table = 'social';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'link', 'platform');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}