<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCollectionTable extends Migration {

	public function up()
	{
		Schema::create('collection', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->nullable();
			$table->integer('width')->nullable();
			$table->integer('height')->nullable();
			$table->text('description')->nullable();
			$table->string('website')->nullable();
			$table->integer('network_id')->nullable();
			$table->integer('user_id')->nullable();
			$table->string('symbol')->nullable();
			$table->integer('size')->nullable();
			$table->text('metadata_cid')->nullable();
			$table->json('preview_tokens')->nullable();
			$table->boolean('is_generated')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('collection');
	}
}