<?php

namespace App/Models;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;

	public function BloodType()
	{
		return $this->belongsToMany('App/Models\BloodType');
	}

	public function City()
	{
		return $this->hasMany('App/Models\City');
	}

	public function Post()
	{
		return $this->belongsToMany('App/Models\Post');
	}

	public function DonationRequest()
	{
		return $this->belongsTo('App/Models\DonationRequest');
	}

	public function Contact()
	{
		return $this->hasMany('App/Models\Contact');
	}

	public function Governates()
	{
		return $this->belongsToMany('App/Models\Governorate');
	}

	public function Notification()
	{
		return $this->belongsToMany('App/Models\Notification');
	}

}