<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateJobsTable extends Migration {

	public function up()
	{
		Schema::create('jobs', function(Blueprint $table) {
			$table->increments('id');
			$table->string('job_name', 255);
			$table->string('specializations', 255)->nullable();
			$table->timestamps();
			$table->boolean('is_official')->default(true);
			$table->enum('status', array('pending', 'approved', 'rejected'));
			$table->integer('added_by')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('jobs');
	}
}