<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePendingReferenceValuesTable extends Migration {

	public function up()
	{
		Schema::create('pending_reference_values', function(Blueprint $table) {
			$table->increments('id');
			$table->string('reference_type', 255);
			$table->string('value', 255);
			$table->integer('memory_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->enum('status', array('pending', 'approved', 'rejected'));
			$table->longText('admin_note');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('pending_reference_values');
	}
}