<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserPrivaciesTable extends Migration {

	public function up()
	{
		Schema::create('user_privacies', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('key');
			$table->enum('privacy', array('public', 'friends', 'private'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('user_privacies');
	}
}