<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInterestsTable extends Migration {

	public function up()
	{
		Schema::create('Interests', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->boolean('is_official')->default(true);
			$table->enum('status', array('pending', 'approved', 'rejected'));
			$table->integer('added_by')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Interests');
	}
}