<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmployersTable extends Migration {

	public function up()
	{
		Schema::create('employers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->boolean('is_official')->default(true);
			$table->enum('status', array('pending', 'approved', 'rejected'));
			$table->integer('added_by')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('employers');
	}
}