<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('regions', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->foreign('region_id')->references('id')->on('regions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->foreign('region_id')->references('id')->on('regions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('generation_id')->references('id')->on('generations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('institutions_id')->references('id')->on('educational_institutions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('specializations', function(Blueprint $table) {
			$table->foreign('institutions_id')->references('id')->on('educational_institutions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_institutions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_institutions', function(Blueprint $table) {
			$table->foreign('institutions_id')->references('id')->on('educational_institutions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->foreign('added_by')->references('id')->on('cities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users_job', function(Blueprint $table) {
			$table->foreign('job_id')->references('id')->on('jobs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users_job', function(Blueprint $table) {
			$table->foreign('employer_id')->references('id')->on('employers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users_job', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Interests', function(Blueprint $table) {
			$table->foreign('added_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_interests', function(Blueprint $table) {
			$table->foreign('Interest_id')->references('id')->on('Interests')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('memories', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('memories', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('memory_tags', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('memory_tags', function(Blueprint $table) {
			$table->foreign('memory_id')->references('id')->on('memories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('memorial_persons', function(Blueprint $table) {
			$table->foreign('memory_id')->references('id')->on('memories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('memorial_persons', function(Blueprint $table) {
			$table->foreign('living_city_id')->references('id')->on('cities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('memorial_persons', function(Blueprint $table) {
			$table->foreign('death_city_id')->references('id')->on('cities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('memorial_persons', function(Blueprint $table) {
			$table->foreign('job_id')->references('id')->on('jobs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('memorial_persons', function(Blueprint $table) {
			$table->foreign('institutions_id')->references('id')->on('educational_institutions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('memory_videos', function(Blueprint $table) {
			$table->foreign('memory_id')->references('id')->on('memories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('memory_likes', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pending_reference_values', function(Blueprint $table) {
			$table->foreign('memory_id')->references('id')->on('memories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pending_reference_values', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('friendships', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('friendships', function(Blueprint $table) {
			$table->foreign('friend_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_photos', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_photos', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_privacies', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('employers', function(Blueprint $table) {
			$table->foreign('added_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('regions', function(Blueprint $table) {
			$table->dropForeign('regions_country_id_foreign');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->dropForeign('cities_region_id_foreign');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->dropForeign('addresses_country_id_foreign');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->dropForeign('addresses_region_id_foreign');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->dropForeign('addresses_city_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_generation_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_institutions_id_foreign');
		});
		Schema::table('specializations', function(Blueprint $table) {
			$table->dropForeign('specializations_institutions_id_foreign');
		});
		Schema::table('user_institutions', function(Blueprint $table) {
			$table->dropForeign('user_institutions_user_id_foreign');
		});
		Schema::table('user_institutions', function(Blueprint $table) {
			$table->dropForeign('user_institutions_institutions_id_foreign');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->dropForeign('jobs_added_by_foreign');
		});
		Schema::table('users_job', function(Blueprint $table) {
			$table->dropForeign('users_job_job_id_foreign');
		});
		Schema::table('users_job', function(Blueprint $table) {
			$table->dropForeign('users_job_employer_id_foreign');
		});
		Schema::table('users_job', function(Blueprint $table) {
			$table->dropForeign('users_job_user_id_foreign');
		});
		Schema::table('Interests', function(Blueprint $table) {
			$table->dropForeign('Interests_added_by_foreign');
		});
		Schema::table('user_interests', function(Blueprint $table) {
			$table->dropForeign('user_interests_Interest_id_foreign');
		});
		Schema::table('memories', function(Blueprint $table) {
			$table->dropForeign('memories_user_id_foreign');
		});
		Schema::table('memories', function(Blueprint $table) {
			$table->dropForeign('memories_city_id_foreign');
		});
		Schema::table('memory_tags', function(Blueprint $table) {
			$table->dropForeign('memory_tags_user_id_foreign');
		});
		Schema::table('memory_tags', function(Blueprint $table) {
			$table->dropForeign('memory_tags_memory_id_foreign');
		});
		Schema::table('memorial_persons', function(Blueprint $table) {
			$table->dropForeign('memorial_persons_memory_id_foreign');
		});
		Schema::table('memorial_persons', function(Blueprint $table) {
			$table->dropForeign('memorial_persons_living_city_id_foreign');
		});
		Schema::table('memorial_persons', function(Blueprint $table) {
			$table->dropForeign('memorial_persons_death_city_id_foreign');
		});
		Schema::table('memorial_persons', function(Blueprint $table) {
			$table->dropForeign('memorial_persons_job_id_foreign');
		});
		Schema::table('memorial_persons', function(Blueprint $table) {
			$table->dropForeign('memorial_persons_institutions_id_foreign');
		});
		Schema::table('memory_videos', function(Blueprint $table) {
			$table->dropForeign('memory_videos_memory_id_foreign');
		});
		Schema::table('memory_likes', function(Blueprint $table) {
			$table->dropForeign('memory_likes_user_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_user_id_foreign');
		});
		Schema::table('pending_reference_values', function(Blueprint $table) {
			$table->dropForeign('pending_reference_values_memory_id_foreign');
		});
		Schema::table('pending_reference_values', function(Blueprint $table) {
			$table->dropForeign('pending_reference_values_user_id_foreign');
		});
		Schema::table('friendships', function(Blueprint $table) {
			$table->dropForeign('friendships_user_id_foreign');
		});
		Schema::table('friendships', function(Blueprint $table) {
			$table->dropForeign('friendships_friend_id_foreign');
		});
		Schema::table('user_photos', function(Blueprint $table) {
			$table->dropForeign('user_photos_user_id_foreign');
		});
		Schema::table('user_photos', function(Blueprint $table) {
			$table->dropForeign('user_photos_city_id_foreign');
		});
		Schema::table('user_privacies', function(Blueprint $table) {
			$table->dropForeign('user_privacies_user_id_foreign');
		});
		Schema::table('employers', function(Blueprint $table) {
			$table->dropForeign('employers_added_by_foreign');
		});
	}
}