<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Coupon extends Eloquent {

	protected $table = 'coupon';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('offer_id', 'number', 'name_en', 'name_ar', 'discount', 'description_en', 'description_ar', 'expired_at', 'status', 'max_uses', 'uses', 'current_uses');

	public function offer()
	{
		return $this->belongsTo('Offer', 'offer_id');
	}

	public function histories()
	{
		return $this->hasMany('CouponHistory', 'coupon_id');
	}

}