<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserTable extends Migration {

	public function up()
	{
		Schema::create('user', function(Blueprint $table) {
			$table->integer('city_id')->nullable();
			$table->enum('status', array('new', 'active', 'inactive'))->nullable();
			$table->integer('max_uses')->nullable();
			$table->integer('uses')->nullable();
			$table->integer('card_id')->nullable();
			$table->integer('card_index')->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('user');
	}
}