<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUniversitiesTable extends Migration {

	public function up()
	{
		Schema::create('universities', function(Blueprint $table) {
			$table->increments('id');
			$table->string('university_name');
			$table->string('website');
			$table->integer('country_id')->unsigned();
			$table->string('city');
			$table->string('title');
			$table->string('name');
			$table->string('position');
			$table->string('current_location');
			$table->string('country_code');
			$table->string('phone');
			$table->string('linkedin');
			$table->string('whatsapp');
			$table->string('logo');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('universities');
	}
}