<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('innovator_id')->references('id')->on('innovators')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('Company')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('vc_id')->references('id')->on('vcs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('innovators', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('innovator_projects', function(Blueprint $table) {
			$table->foreign('field_id')->references('id')->on('fields')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('innovator_projects', function(Blueprint $table) {
			$table->foreign('innovator_id')->references('id')->on('innovators')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Company', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('universities', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('vcs', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('vc_investements', function(Blueprint $table) {
			$table->foreign('vs_id')->references('id')->on('vcs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('vc_investements', function(Blueprint $table) {
			$table->foreign('field_id')->references('id')->on('fields')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('mentor_educations', function(Blueprint $table) {
			$table->foreign('mentor_id')->references('id')->on('mentors')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('mentor_research_filds', function(Blueprint $table) {
			$table->foreign('mentor_id')->references('id')->on('mentors')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('mentor_research_filds', function(Blueprint $table) {
			$table->foreign('field_id')->references('id')->on('fields')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('mentor_employments', function(Blueprint $table) {
			$table->foreign('mentor_id')->references('id')->on('mentors')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('mentor_languges', function(Blueprint $table) {
			$table->foreign('mentor_id')->references('id')->on('mentors')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('mentor_skills', function(Blueprint $table) {
			$table->foreign('mentor_id')->references('id')->on('mentors')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('mentor_work_cultures', function(Blueprint $table) {
			$table->foreign('mentor_id')->references('id')->on('mentors')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('career_educations', function(Blueprint $table) {
			$table->foreign('career_id')->references('id')->on('careers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('career_employments', function(Blueprint $table) {
			$table->foreign('career_id')->references('id')->on('careers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('career_languges', function(Blueprint $table) {
			$table->foreign('carrer_id')->references('id')->on('careers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('career_skills', function(Blueprint $table) {
			$table->foreign('career_id')->references('id')->on('careers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('carrer_work_culture', function(Blueprint $table) {
			$table->foreign('career_id')->references('id')->on('careers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('career_activites', function(Blueprint $table) {
			$table->foreign('career_id')->references('id')->on('careers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('career_refrences', function(Blueprint $table) {
			$table->foreign('career_id')->references('id')->on('careers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('researcher_educations', function(Blueprint $table) {
			$table->foreign('researcher_id')->references('id')->on('researchers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('researcher_fields', function(Blueprint $table) {
			$table->foreign('researcher_id')->references('id')->on('researchers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('researcher_fields', function(Blueprint $table) {
			$table->foreign('field_id')->references('id')->on('fields')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('researcher_employments', function(Blueprint $table) {
			$table->foreign('researcher_id')->references('id')->on('researchers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('researcher_skills', function(Blueprint $table) {
			$table->foreign('researcher_id')->references('id')->on('researchers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('researcher_work_cultures', function(Blueprint $table) {
			$table->foreign('researcher_id')->references('id')->on('researchers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_innovator_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_company_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_vc_id_foreign');
		});
		Schema::table('innovators', function(Blueprint $table) {
			$table->dropForeign('innovators_country_id_foreign');
		});
		Schema::table('innovator_projects', function(Blueprint $table) {
			$table->dropForeign('innovator_projects_field_id_foreign');
		});
		Schema::table('innovator_projects', function(Blueprint $table) {
			$table->dropForeign('innovator_projects_innovator_id_foreign');
		});
		Schema::table('Company', function(Blueprint $table) {
			$table->dropForeign('Company_country_id_foreign');
		});
		Schema::table('universities', function(Blueprint $table) {
			$table->dropForeign('universities_country_id_foreign');
		});
		Schema::table('vcs', function(Blueprint $table) {
			$table->dropForeign('vcs_country_id_foreign');
		});
		Schema::table('vc_investements', function(Blueprint $table) {
			$table->dropForeign('vc_investements_vs_id_foreign');
		});
		Schema::table('vc_investements', function(Blueprint $table) {
			$table->dropForeign('vc_investements_field_id_foreign');
		});
		Schema::table('mentor_educations', function(Blueprint $table) {
			$table->dropForeign('mentor_educations_mentor_id_foreign');
		});
		Schema::table('mentor_research_filds', function(Blueprint $table) {
			$table->dropForeign('mentor_research_filds_mentor_id_foreign');
		});
		Schema::table('mentor_research_filds', function(Blueprint $table) {
			$table->dropForeign('mentor_research_filds_field_id_foreign');
		});
		Schema::table('mentor_employments', function(Blueprint $table) {
			$table->dropForeign('mentor_employments_mentor_id_foreign');
		});
		Schema::table('mentor_languges', function(Blueprint $table) {
			$table->dropForeign('mentor_languges_mentor_id_foreign');
		});
		Schema::table('mentor_skills', function(Blueprint $table) {
			$table->dropForeign('mentor_skills_mentor_id_foreign');
		});
		Schema::table('mentor_work_cultures', function(Blueprint $table) {
			$table->dropForeign('mentor_work_cultures_mentor_id_foreign');
		});
		Schema::table('career_educations', function(Blueprint $table) {
			$table->dropForeign('career_educations_career_id_foreign');
		});
		Schema::table('career_employments', function(Blueprint $table) {
			$table->dropForeign('career_employments_career_id_foreign');
		});
		Schema::table('career_languges', function(Blueprint $table) {
			$table->dropForeign('career_languges_carrer_id_foreign');
		});
		Schema::table('career_skills', function(Blueprint $table) {
			$table->dropForeign('career_skills_career_id_foreign');
		});
		Schema::table('carrer_work_culture', function(Blueprint $table) {
			$table->dropForeign('carrer_work_culture_career_id_foreign');
		});
		Schema::table('career_activites', function(Blueprint $table) {
			$table->dropForeign('career_activites_career_id_foreign');
		});
		Schema::table('career_refrences', function(Blueprint $table) {
			$table->dropForeign('career_refrences_career_id_foreign');
		});
		Schema::table('researcher_educations', function(Blueprint $table) {
			$table->dropForeign('researcher_educations_researcher_id_foreign');
		});
		Schema::table('researcher_fields', function(Blueprint $table) {
			$table->dropForeign('researcher_fields_researcher_id_foreign');
		});
		Schema::table('researcher_fields', function(Blueprint $table) {
			$table->dropForeign('researcher_fields_field_id_foreign');
		});
		Schema::table('researcher_employments', function(Blueprint $table) {
			$table->dropForeign('researcher_employments_researcher_id_foreign');
		});
		Schema::table('researcher_skills', function(Blueprint $table) {
			$table->dropForeign('researcher_skills_researcher_id_foreign');
		});
		Schema::table('researcher_work_cultures', function(Blueprint $table) {
			$table->dropForeign('researcher_work_cultures_researcher_id_foreign');
		});
	}
}