<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('market_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('market_user', function(Blueprint $table) {
			$table->foreign('market_id')->references('id')->on('markets')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('market_config', function(Blueprint $table) {
			$table->foreign('market_id')->references('id')->on('markets')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('wallets', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('item_market', function(Blueprint $table) {
			$table->foreign('market_id')->references('id')->on('markets')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('item_market', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('items')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('portfolio', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('portfolio', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('items')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('portfolio', function(Blueprint $table) {
			$table->foreign('market_id')->references('id')->on('markets')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('market_user', function(Blueprint $table) {
			$table->dropForeign('market_user_user_id_foreign');
		});
		Schema::table('market_user', function(Blueprint $table) {
			$table->dropForeign('market_user_market_id_foreign');
		});
		Schema::table('market_config', function(Blueprint $table) {
			$table->dropForeign('market_config_market_id_foreign');
		});
		Schema::table('wallets', function(Blueprint $table) {
			$table->dropForeign('wallets_user_id_foreign');
		});
		Schema::table('item_market', function(Blueprint $table) {
			$table->dropForeign('item_market_market_id_foreign');
		});
		Schema::table('item_market', function(Blueprint $table) {
			$table->dropForeign('item_market_item_id_foreign');
		});
		Schema::table('portfolio', function(Blueprint $table) {
			$table->dropForeign('portfolio_user_id_foreign');
		});
		Schema::table('portfolio', function(Blueprint $table) {
			$table->dropForeign('portfolio_item_id_foreign');
		});
		Schema::table('portfolio', function(Blueprint $table) {
			$table->dropForeign('portfolio_market_id_foreign');
		});
	}
}