<?php

namespace App\Models;

class DonationRequest extends Eloquent {

	protected $table = 'donation_requests';
	public $timestamps = true;
	protected $fillable = array('patient_name', 'patient_phone', 'city_id', 'hospital_name', 'blood_type_id', 'patient_age', 'bags_num', 'hospital_address', 'details', 'latitude', 'longitude', 'client_id');

	public function city()
	{
		return $this->belongsTo('App\Models\City');
	}

	public function bloodType()
	{
		return $this->belongsTo('App\Models\BloodType');
	}

	public function client()
	{
		return $this->belongsTo('App\Models\Client');
	}

	public function notification()
	{
		return $this->hasOne('App\Models\Notification');
	}

}