<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('ruptl_proposal', function(Blueprint $table) {
			$table->foreign('id_jenis_usulan')->references('id_jenis_usulan')->on('m_jenis_usulan')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('ruptl_proposal', function(Blueprint $table) {
			$table->foreign('id_provinsi')->references('id_provinsi')->on('m_provinsi')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('dokumen', function(Blueprint $table) {
			$table->foreign('id_jenis_dokumen')->references('id_jenis_dokumen')->on('m_jenis_dokumen')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('ruptl_proposal', function(Blueprint $table) {
			$table->dropForeign('ruptl_proposal_id_jenis_usulan_foreign');
		});
		Schema::table('ruptl_proposal', function(Blueprint $table) {
			$table->dropForeign('ruptl_proposal_id_provinsi_foreign');
		});
		Schema::table('dokumen', function(Blueprint $table) {
			$table->dropForeign('dokumen_id_jenis_dokumen_foreign');
		});
	}
}