<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Account extends Eloquent {

	protected $table = 'accounts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('vendor');

	public function institution()
	{
		return $this->belongsTo('App\User');
	}

	public function creator()
	{
		return $this->belongsTo('App\User');
	}

	public function updated()
	{
		return $this->belongsTo('App\User');
	}

}